%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% file: exampleETH.m                                                      %
%                                                                         %
% brief: This is an example for getting data form channel 0 and 1      .  %
%                                                                         %
% autor: Benedikt Radl                                                    %
%                                                                         %
% Copyright (c) 2015 Bluetechnix Group GmbH                               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% get a config structure
[status, configStruct] = BTAinitConfig;
if status ~= 0
    error('BTAinitConfig failed. See "status" for error description');
end

% fill the config struct
configStruct.udpDataIpAddr = [224, 0, 0, 1];
configStruct.udpDataIpAddrLen = 4;
configStruct.udpDataPort = 10002;
configStruct.tcpDeviceIpAddr = [192, 168, 0, 10];
configStruct.tcpDeviceIpAddrLen = 4;
configStruct.tcpControlPort = 10001;
configStruct.frameMode = 0;
configStruct.frameQueueMode = 1;
configStruct.frameQueueLength = 5;
configStruct.deviceType = 1; %ETH generic

% open device
[status, deviceHandle] = BTAopen(configStruct);
if status ~= 0
    error('BTAopen failed. See "status" for error description');
end

% set framemode to 24
[status] = BTAwriteRegister(deviceHandle, 4, 192);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAreadRegister failed. See "status" for error description');
end
%wait some time that the changes take effect
pause(2); 

% get one frame
[status, frameHandle, frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAgetFrame failed. See "status" for error description');
end

% get data form channel 0
[status, channel0Data, channelID, integrationTime, modulationFrequency, unit] = BTAgetChannelData(frameHandle, 0);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetChannelData failed. See "status" for error description');
end

% get data form channel 1
[status, channel1Data, channelID, integrationTime, modulationFrequency, unit] = BTAgetChannelData(frameHandle, 1);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetChannelData failed. See "status" for error description');
end

% free frame
[status] = BTAfreeFrame(frameHandle);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAfreeFrame failed. See "status" for error description');
end

%create window for channel 0
figure('name','Channel 0 data');
set(gcf,'NumberTitle','off')
%set color range from 0 to 65535
clims  = [0 65535];
hCh0 = imagesc(channel0Data, clims);
colorbar;
colormap('GRAY');

global MK;
MK=0;
set(gcf,'KeyPressFcn','MK=1;');

%create window for channel 1 
figure('name','Channel 1 data');
set(gcf,'NumberTitle','off')
%set color range from 0 to 65535 
clims  = [0 65535];
hCh1=imagesc(channel1Data, clims);
colorbar;
colormap('GRAY');

global MK2;
MK2=0;
set(gcf,'KeyPressFcn','MK2=1;');

ch1WindowIsclosed = 0;
ch0WindowIsclosed = 0;
%loop 
while ~MK && ~MK2 && ~(ch1WindowIsclosed && ch0WindowIsclosed)
    % get one frame
    [status, frameHandle,  frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
    if status == 0
        %get data from channel 0
        [status, channel0Data, channelID, integrationTime, modulationFrequency, unit] = BTAgetChannelData(frameHandle, 0);
        if status == 0
            if ishandle(hCh0)
                %display data
                set(hCh0,'CData',channel0Data);
                refreshdata(hCh0);
            else
                ch0WindowIsclosed = 1;
            end
        end
        %get data from channel 1
        [status, channel1Data, channelID, integrationTime, modulationFrequency, unit] = BTAgetChannelData(frameHandle, 1);
        if status == 0
            if ishandle(hCh1)
                %display data
                set(hCh1,'CData',channel1Data);
                refreshdata(hCh1);
            else
                ch1WindowIsclosed = 1;   
            end
        end
        %free frame
        [status] = BTAfreeFrame(frameHandle);
        if status ~= 0
            error('BTAfreeFrame failed. See "status" for error description');
        end
    end
    pause(0.1); 
end

%close device
status = BTAclose(deviceHandle);
if status ~= 0
	error('BTAclose failed. See "status" for error description');
end

close all;
clear all;


